// RFID1AddressedCommandsDlg.cpp : implementation file
#include "stdafx.h"
#include "RFID1AddressedCommands.h"
#include "RFID1AddressedCommandsDlg.h"
#include "FTD2XX.h"
#include "FTChipID.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
// CAboutDlg dialog used for App About



#define ascitohex(c)    (c <= '9' ? c - '0' : ((c <= 'F') ? c-'A'+10 : c - 'a'+10 ))

#define MYBUFFERSIZE 3000
unsigned char grx[MYBUFFERSIZE];//global receive buffer

int valid_port;
int	process_active;
FT_HANDLE m_ftHandle;

int data8[8];//array for holding 8 blocks



class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
// CRFID1AddressedCommandsDlg dialog



CRFID1AddressedCommandsDlg::CRFID1AddressedCommandsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRFID1AddressedCommandsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRFID1AddressedCommandsDlg)
	m_NumTags = _T("");
	m_Addr = _T("00");
	m_Data = _T("");
	m_DSFID = _T("");
	m_TagType = _T("");
	m_UID = _T("");
	m_AFI = _T("");
	m_DSFID_Status = _T("");
	m_MemSize = _T("");
	m_AFI2Write = _T("");
	m_PW = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRFID1AddressedCommandsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRFID1AddressedCommandsDlg)
	DDX_Control(pDX, IDC_COMBO_ADDR_LOCK_READ, m_LockRead);
	DDX_Control(pDX, IDC_COMBO_ADDR_MULTI_READ, m_MiltiRead);
	DDX_Control(pDX, IDC_LIST1, m_SniffList);
	DDX_Text(pDX, IDC_EDIT_NUM_TAGS, m_NumTags);
	DDX_Text(pDX, IDC_EDIT_ADDR_BLOCK_ADDR, m_Addr);
	DDX_Text(pDX, IDC_EDIT_ADDR_BLOCK_DATA, m_Data);
	DDX_Text(pDX, IDC_EDIT_DSFID_2WRITE, m_DSFID);
	DDX_Text(pDX, IDC_EDIT_TAG_TYPE, m_TagType);
	DDX_Text(pDX, IDC_EDIT_UID, m_UID);
	DDX_Text(pDX, IDC_EDIT_AFI, m_AFI);
	DDX_Text(pDX, IDC_EDIT_DSFID, m_DSFID_Status);
	DDX_Text(pDX, IDC_EDIT_MEM_SIZE, m_MemSize);
	DDX_Text(pDX, IDC_EDIT_AFI2WRITE, m_AFI2Write);
	DDX_Text(pDX, IDC_EDIT_PASSWORD, m_PW);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRFID1AddressedCommandsDlg, CDialog)
	//{{AFX_MSG_MAP(CRFID1AddressedCommandsDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_RESET, OnButtonReset)
	ON_BN_CLICKED(IDC_BUTTON_STAY_QUIET, OnButtonStayQuiet)
	ON_BN_CLICKED(IDC_BUTTON_ADDR_READ_BLOCK, OnButtonAddrReadBlock)
	ON_BN_CLICKED(IDC_BUTTON_ADDR_WRITE_SINGLE, OnButtonAddrWriteSingle)
	ON_BN_CLICKED(IDC_BUTTON_ADDR_LOCK_BLOCK, OnButtonAddrLockBlock)
	ON_BN_CLICKED(IDC_BUTTON_ADDR_READ_MULT, OnButtonAddrReadMult)
	ON_BN_CLICKED(IDC_BUTTON_DSFUID_WRITE, OnButtonDsfuidWrite)
	ON_BN_CLICKED(IDC_BUTTON_READ_STATUS, OnButtonReadStatus)
	ON_BN_CLICKED(IDC_BUTTON_DSFID_LOCK, OnButtonDsfidLock)
	ON_BN_CLICKED(IDC_BUTTON_AFI_WRITE, OnButtonAfiWrite)
	ON_BN_CLICKED(IDC_BUTTON_AFI_LOCK, OnButtonAfiLock)
	ON_BN_CLICKED(IDC_BUTTON_ADDR_READ_LOCKSTATE, OnButtonAddrReadLockstate)
	ON_BN_CLICKED(IDC_BUTTON_KILL, OnButtonKill)
	ON_BN_CLICKED(IDC_BUTTON_ADDR_WRITE_WITHPASSWORD, OnButtonAddrWriteWithpassword)
	ON_BN_CLICKED(IDC_BUTTON_READ_SERIAL, OnButtonReadSerial)
	ON_BN_CLICKED(IDC_BUTTON_CH1, OnButtonCh1)
	ON_BN_CLICKED(IDC_BUTTON_CH2, OnButtonCh2)
	ON_BN_CLICKED(IDC_BUTTON_CH3, OnButtonCh3)
	ON_BN_CLICKED(IDC_BUTTON_CH4, OnButtonCh4)
	ON_BN_CLICKED(IDC_BUTTON_CH5, OnButtonCh5)
	ON_BN_CLICKED(IDC_BUTTON_CH6, OnButtonCh6)
	ON_BN_CLICKED(IDC_BUTTON_CH7, OnButtonCh7)
	ON_BN_CLICKED(IDC_BUTTON_CH8, OnButtonCh8)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
// CRFID1AddressedCommandsDlg message handlers



void CRFID1AddressedCommandsDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRFID1AddressedCommandsDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRFID1AddressedCommandsDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


//**********************************************************************************
BOOL CRFID1AddressedCommandsDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	valid_port=0;
	process_active=0;
	
	OpenPort(1, 1, 1);//reset, beep, notify_open in listbox

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//**********************************************************************************************
int CRFID1AddressedCommandsDlg::OpenPort(int reset, int beep, int notify_open)
{
	DWORD numDevs;
	int res;
	CString sss;

	valid_port=0;//init
	FT_STATUS status = FT_ListDevices(&numDevs, NULL, FT_LIST_NUMBER_ONLY);
	if(status == FT_OK) 
	{
		if((int)numDevs > 0)
		{
			FT_STATUS status = FT_OpenEx((PVOID)(LPCTSTR)"DLP-RFID1", FT_OPEN_BY_DESCRIPTION, &m_ftHandle);
			if(status != FT_OK) 
			{
				AfxMessageBox("Error: Could not open DLP-RFID1 Reader.");				
				return 1;
			}
			else
			{
				FT_Purge(m_ftHandle, FT_PURGE_RX || FT_PURGE_TX); 
				FT_SetTimeouts(m_ftHandle, 100, 100);
				FT_SetBaudRate(m_ftHandle, 115200);

				if(reset)
				{
					//set DTR
					status = FT_SetDtr(m_ftHandle);
					Sleep(20); //wait for cap to charge
					//Clear DTR
					status = FT_ClrDtr(m_ftHandle);
					Sleep(2010);//wait for micro to start up
				}


				res = PingReader();
				if(res==0)//no error
				{
					if(beep)
						SendBeep1();

					if(notify_open)
					{
						sss.Format("Port Open, RFID1 Ready");
						m_SniffList.InsertString(0,sss);
						UpdateWindow();
					}
				}
				else
				{
					sss.Format("No RFID1 Detected");
					m_SniffList.InsertString(0,sss);
					UpdateWindow();
					//AfxMessageBox("Error: No reader detected.");				
					return 2;
				}
			}
		}
		else
		{
			sss.Format("No RFID1 Detected");
			m_SniffList.InsertString(0,sss);
			UpdateWindow();
			//AfxMessageBox("Error: No reader detected.");				
			return 2;
		}
	}
	else
	{
		sss.Format("No RFID1 Detected");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		//AfxMessageBox("Error: No reader detected.");	
		return 3;
	}

	return 0;
}





//*********************************************************************************
void CRFID1AddressedCommandsDlg::SendBeep1() 
{
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	unsigned char tx[600], rx[6000];
	CString stra, str;
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	//tx[pos++] = 0x31;//1
	//tx[pos++] = 0x39;//9
	tx[pos++] = 0x37;//7
	tx[pos++] = 0x37;//7
		
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(100);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

}



//**********************************************************************************************
int CRFID1AddressedCommandsDlg::PingReader() 
{
	FT_STATUS status;
	unsigned char tx[60], rx[60];
	CString stra, str, sss;
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	
	//Ping the port and check for correct response
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x38;//8

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x46;//F
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	status = FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

	if(BytesReturned < 3)
	{
		sss.Format("RFID1 not found");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		return 1;
	}

	for(DWORD x=0; x<BytesReturned; x++)
	{
		stra.Format("%c", rx[x]);
		str+=stra;
	}

	if(str.Find("DLP-RFID", 0))
	{
		//pass
		valid_port=1;//this is the only place valid_port can be set
		PurgePort();
	}
	else
	{
		//fail
		sss.Format("RFID1 not found");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		return 2;
	}
	
	int ret = PurgePort();
	//if(ret)//if any data is still in the buffer then warn
	//	AfxMessageBox("Warning: extra data in buffer...");

	return 0;
}



//**********************************************************************
int CRFID1AddressedCommandsDlg::PurgePort()
{
	int total_bytes_found;
	DWORD AmountInRxQueue, BytesReturned;

	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	total_bytes_found=AmountInRxQueue;//init counter
	while(AmountInRxQueue)
	{
		FT_Read(m_ftHandle, grx, AmountInRxQueue, &BytesReturned);
		Sleep(10);//wait for more to arrive
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		total_bytes_found += AmountInRxQueue;
	}

	for(int x=0; x<MYBUFFERSIZE; x++)
		grx[x]=0xcc;

	return total_bytes_found;
}




//**********************************************************************
void CRFID1AddressedCommandsDlg::OnButtonStart() 
{
	//turn off the channel select buttons
//	pConfEdit = (CEdit *)GetDlgItem(IDC_EDIT_FUSE); //editable/
//	pConfEdit->SetReadOnly( FALSE );

//	GetDlgItem(IDC_BUTTON_CH1)->SetReadOnly( FALSE );



	SetTimer(100, 250, NULL);
}



//**********************************************************************
void CRFID1AddressedCommandsDlg::OnButtonStop() 
{
	KillTimer(100);

    m_SniffList.SetSel(0, TRUE);
	UpdateWindow();
}




//**********************************************************************
void CRFID1AddressedCommandsDlg::OnTimer(UINT nIDEvent) 
{
	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	if(process_active)
		return;
	process_active=1;

	ReadBoth();
	
	process_active=0;

	
	CDialog::OnTimer(nIDEvent);
}



//**********************************************************************
void CRFID1AddressedCommandsDlg::ReadBoth() 
{
	DWORD BytesWritten;
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;
	int TotNumTags;



	SendRegwrtreq(1);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	int ret = PurgePort();
	//if(ret)
	//	AfxMessageBox("data in buffer 7...");

	m_SniffList.ResetContent();
	UpdateWindow();


	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	ret_bytes = GetBufferSlow();

//	m_SniffList.ResetContent();
//	UpdateWindow();
	TotNumTags=0;

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);
				m_SniffList.InsertString(0,"UID:"+sss);//display the UID
				TotNumTags++;
			}
		}
	}


	if(TotNumTags<1)
	{
		CString sss;
		sss.Format("No tags found");
		m_SniffList.InsertString(0, sss);
	}
	

	ret = PurgePort();
	//if(ret)
	//	AfxMessageBox("data in buffer 7...");

}




//**********************************************************************
void CRFID1AddressedCommandsDlg::SendRegwrtreq(int mode)//0=usermem, 1=UID //15693 Setup
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0

	//0=usermem, 1=UID
	if(mode==0)
		tx[pos++] = 0x30;// 0 for memory read/write
	if(mode==1)
		tx[pos++] = 0x32;// 2 for UID read

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int ret = FastRead(51, 50);
}




//**********************************************************************
void CRFID1AddressedCommandsDlg::SendAgcToggle() 
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int ret = FastRead(20, 50);

}




//**********************************************************************
void CRFID1AddressedCommandsDlg::SendAmPmToggle() 
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x31;//1
		
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x46;//F

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int ret = FastRead(20, 50);
	//if(ret != 22)
	//{
	//	KillTimer(100);
	//	AfxMessageBox("fastread failed21");	
	//}

	
}




//**********************************************************************
void CRFID1AddressedCommandsDlg::OnButton15693invReq() 
{
	DWORD BytesWritten;
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;

	m_SniffList.ResetContent();
	UpdateWindow();

	int ret = PurgePort();
	//if(ret)
	//	AfxMessageBox("data in buffer 4...");


	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0


	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int res = ret_bytes = FastRead(53, 50);
	//if(res != 53)
	//{
	//	KillTimer(100);
	//	AfxMessageBox("fastread failed4");	
	//}


	m_SniffList.ResetContent();

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				str+=stra;
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);
				m_SniffList.InsertString(0,"UID:"+sss);//display the UID
				UpdateWindow();
			}
		}
	}
}





//**********************************************************************
void CRFID1AddressedCommandsDlg::SendRegwrtreqTagit() 
{
	DWORD BytesWritten;
	unsigned char tx[600];
	CString stra, str;
	
//0x30 = 0
//0x39 = 9
//0x41 = A
//0x42 = B
//0x43 = C
//0x44 = D
//0x45 = E
//0x46 = F

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x33;//3

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0


	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int ret = FastRead(53, 100);
	//if(ret != 53)
	//{
	//	KillTimer(100);
 	//	AfxMessageBox("fastread failed22");	
	//}

}



//**********************************************************************
void CRFID1AddressedCommandsDlg::SidpollReq() 
{
	DWORD BytesWritten;
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;

	m_SniffList.ResetContent();
	UpdateWindow();

	int ret = PurgePort();
	//if(ret)
	//	AfxMessageBox("data in buffer 5...");


	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x35;//5
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	int res = ret_bytes = FastRead(53, 50);
	//if(res != 53)
	//{
	//	KillTimer(100);
	//	AfxMessageBox("fastread failed23");	
	//}


	m_SniffList.ResetContent();

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				str+=stra;
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=19;
 				for(int t=0; t<20; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);
				m_SniffList.InsertString(0,"SID:"+sss);//display the UID
				UpdateWindow();
			}
		}
	}
}


//**********************************************************************
DWORD CRFID1AddressedCommandsDlg::GetBufferSlow()
{
	unsigned char temprx[3];
	DWORD AmountInRxQueue, BytesReturned;
	int timeoutcount;

	int found=0, index=0;
	while(!found)//while have not found the ">" character
	{
		timeoutcount=0;
		AmountInRxQueue=0;
		while (AmountInRxQueue==0)//wait for at least one byte in the buffer with timeout
		{
			timeoutcount++;
			if(timeoutcount>250)
			{
				//KillTimer(100);
				//AfxMessageBox("error waiting for one byte");
				break;
			}
			FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
			if(AmountInRxQueue==0)//if no byte received then take a nap and wait for more bytes to arrive
				Sleep(1);
		}

		if(AmountInRxQueue>0)//if one byte is ready to be read
		{
			FT_Read(m_ftHandle, temprx, 1, &BytesReturned);//read in 1 byte at a time

			if(temprx[0] == '>')//if > character received then set the flag and clear the buffer which should be empty
			{
				found=1;
				FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
				FT_Read(m_ftHandle, temprx, AmountInRxQueue, &BytesReturned);//read in 1 byte at a time
			}

			grx[index++] = temprx[0];
			if(index > MYBUFFERSIZE-10)
			{
				found=1;//terminate loop/function
				int ret = PurgePort();
				//if(ret)
				//	AfxMessageBox("data in buffer 6...");

				index=0;
			}
		}
		else//timeout
		{
			PurgePort();//we got a timeout and likely a partial packet so purge and return
			return 0;
		}
	}

	return index;
}



//**********************************************************************
DWORD CRFID1AddressedCommandsDlg::FastRead(int count, int timeout)
{
	DWORD AmountInRxQueue, BytesReturned;

	
	if(count>MYBUFFERSIZE)
	{
		KillTimer(100);
		AfxMessageBox("array error 2");
		return 1;
	}

	AmountInRxQueue=0;
	while((timeout--) && (AmountInRxQueue<(DWORD)count))
	{
		Sleep(1);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	}

	if(AmountInRxQueue <= (DWORD)count)
		FT_Read(m_ftHandle, grx, AmountInRxQueue, &BytesReturned);
	else
		FT_Read(m_ftHandle, grx, count, &BytesReturned);

	return AmountInRxQueue;
}



//**************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonReset() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x46;//f
	tx[pos++] = 0x46;//f
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

//	Sleep(110);//wait for micro to start up

	//set DTR
	FT_SetDtr(m_ftHandle);
	Sleep(20); //wait for cap to charge
	//Clear DTR
	FT_ClrDtr(m_ftHandle);
	Sleep(2010);//wait for micro to start up

	int ret = PingReader();
	if(ret)
		AfxMessageBox("Ping failed.");
}






//**************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonStayQuiet() 
{
	unsigned char rx[1000], tx[1000], strr[300];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	int nIndex, n;

	CString str, str2;
	KillTimer(100);


	SendRegwrtreq(1);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	//int i = m_SniffList.GetCount();
	nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}

    n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header

//  E007 0000 23F4 6572
//	7265 F423 0000 07E0 **

//	E007 0000 2404 06AC 
//	0112000304 182002 AC060424000007E0 0000

	//and write it

	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];


	//build and send the Read block command
	int pos=0;
//	0112000304 182002 AC060424000007E0 0000
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8		
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	
	tx[pos++] = b14;//data
	tx[pos++] = b15;//data
	tx[pos++] = b12;//data
	tx[pos++] = b13;//data
	tx[pos++] = b10;//data
	tx[pos++] = b11;//data
	tx[pos++] = b8;//data
	tx[pos++] = b9;//data
	tx[pos++] = b6;//data
	tx[pos++] = b7;//data
	tx[pos++] = b4;//data
	tx[pos++] = b5;//data
	tx[pos++] = b2;//data
	tx[pos++] = b3;//data
	tx[pos++] = b0;//data
	tx[pos++] = b1;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}




//*************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAddrReadBlock() 
{
	//unsigned char rx[1000], tx[1000];
	//DWORD AmountInRxQueue, BytesReturned;
	int nIndex, n;
	CString stra;
	int address;


//	DWORD x;
	CString str;
	CString str2;

	
	KillTimer(100);


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}


	nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}

    n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header


	UpdateData(TRUE);
	if( (m_Addr.GetLength() > 2) || (m_Addr.GetLength() < 1))
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	UpdateData(TRUE);
	m_Data.Format(" ");
	UpdateData(FALSE);
	UpdateWindow();				


	address = hex2dec((char *)(LPCTSTR)m_Addr);	

	DWORD x = ReadAddressedBlock(address, str2);
	
	UpdateData(TRUE);
	m_Data.Format("%08.8X", x);
	UpdateData(FALSE);
	UpdateWindow();				



}





//*****************************************************************************
DWORD CRFID1AddressedCommandsDlg::ReadAddressedBlock(int addr, CString uid)
{
	unsigned char rx[1000], tx[1000], strr[300];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	CString stra;
	char str_src[3000];
	char str_dest[3000];
	DWORD x;
	CString str;
	CString str2;

  
	sprintf((char *)strr, "%02.2X", addr);

	int s1 = strr[0];//F
	int s2 = strr[1];//E

	sprintf((char *)strr, "%s", (LPCTSTR)uid);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];


	//build and send the Read block command
	//0113000304 182020 7265F423000007E0 03 0000	
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8		
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	
	tx[pos++] = b14;//UID
	tx[pos++] = b15;
	tx[pos++] = b12;
	tx[pos++] = b13;
	tx[pos++] = b10;
	tx[pos++] = b11;
	tx[pos++] = b8;
	tx[pos++] = b9;
	tx[pos++] = b6;
	tx[pos++] = b7;
	tx[pos++] = b4;
	tx[pos++] = b5;
	tx[pos++] = b2;
	tx[pos++] = b3;
	tx[pos++] = b0;
	tx[pos++] = b1;

	tx[pos++] = s1;//addr
	tx[pos++] = s2;//addr

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(100);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

	for(x=0; x<BytesReturned; x++)
	{
		if(rx[x] == '[')
		{
			x++;
			str.Format(" ");
			while(rx[x] != ']')
			{
				stra.Format("%c", rx[x]);
				x++;
				str+=stra;
			}
		
			if(str.GetLength() >10)//if a read was performed
			{
				strcpy(str_src, (LPCTSTR)str);
				//byte reverse
				int ptr=9;
				for(int t=0; t<8; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				DWORD x = hex2dec(str_dest);
				return x;
			
			}
		}
	}

	return 0;

}




//*****************************************************************************
DWORD CRFID1AddressedCommandsDlg::hex2dec(char *addr)
{
	DWORD a, b, c, d, e, f, g, h;

	if(strlen(addr) == 1)
		return ascitohex(*addr);

	if(strlen(addr) == 2)
	{
		a = ascitohex(*addr) << 4;
		addr++;
		b = ascitohex(*addr);
		return a | b;
	}

	if(strlen(addr) == 3)
	{
		a = ascitohex(*addr) << 8;
		addr++;
		b = ascitohex(*addr) << 4;
		addr++;
		c = ascitohex(*addr);
		return a | b | c;
	}

	if(strlen(addr) == 4)
	{
		a = ascitohex(*addr) << 12;
		addr++;
		b = ascitohex(*addr) << 8;
		addr++;
		c = ascitohex(*addr) << 4;
		addr++;
		d = ascitohex(*addr);
		return a | b | c | d;
	}

	if(strlen(addr) == 5)
	{
		a = ascitohex(*addr) << 16;
		addr++;
		b = ascitohex(*addr) << 12;
		addr++;
		c = ascitohex(*addr) << 8;
		addr++;
		d = ascitohex(*addr) << 4;
		addr++;
		e = ascitohex(*addr);
		return a | b | c | d | e;
	}

	if(strlen(addr) == 6)
	{
		a = ascitohex(*addr) << 20;
		addr++;
		b = ascitohex(*addr) << 16;
		addr++;
		c = ascitohex(*addr) << 12;
		addr++;
		d = ascitohex(*addr) << 8;
		addr++;
		e = ascitohex(*addr) << 4;
		addr++;
		f = ascitohex(*addr);
		return a | b | c | d | e | f;
	}

	if(strlen(addr) == 7)
	{
		a = ascitohex(*addr) << 24;
		addr++;
		b = ascitohex(*addr) << 20;
		addr++;
		c = ascitohex(*addr) << 16;
		addr++;
		d = ascitohex(*addr) << 12;
		addr++;
		e = ascitohex(*addr) << 8;
		addr++;
		f = ascitohex(*addr) << 4;
		addr++;
		g = ascitohex(*addr);
		return a | b | c | d | e | f | g;
	}
	
	if(strlen(addr) == 8)
	{
		DWORD x;

		x=0;
		a = ascitohex(*addr) << 28;
		addr++;
		x |= a;
		b = ascitohex(*addr) << 24;
		addr++;
		x |= b;
		c = ascitohex(*addr) << 20;
		addr++;
		x |= c;
		d = ascitohex(*addr) << 16;
		addr++;
		x |= d;
		e = ascitohex(*addr) << 12;
		addr++;
		x |= e;
		f = ascitohex(*addr) << 8;
		addr++;
		x |= f;
		g = ascitohex(*addr) << 4;
		addr++;
		x |= g;
		h = ascitohex(*addr);
		x |= h;

		//x = a | b | c | d | e | f | g | h; 

		return x;
	}

	return 0;
}





//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAddrWriteSingle() 
{
	CString stra, str, str2;
	int address, data;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	UpdateData(TRUE);
	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	if(m_Data.GetLength() != 8)
	{
		AfxMessageBox("Invalid Entry.  Range: 00000000-FFFFFFFF");
		return;
	}

	address = hex2dec((char *)(LPCTSTR)m_Addr);	
	data =  hex2dec((char *)(LPCTSTR)m_Data);	


	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header

	WriteAddressedBlock(address, data, str2);
}





//*****************************************************************************
void CRFID1AddressedCommandsDlg::WriteAddressedBlock(int address, int data, CString uid)
{
	CString stra, str, str2;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x37;//7

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x31;//1

	sprintf((char *)strr, "%s", (LPCTSTR)uid);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];

	tx[pos++] = b14;//UID
	tx[pos++] = b15;
	tx[pos++] = b12;
	tx[pos++] = b13;
	tx[pos++] = b10;
	tx[pos++] = b11;
	tx[pos++] = b8;
	tx[pos++] = b9;
	tx[pos++] = b6;
	tx[pos++] = b7;
	tx[pos++] = b4;
	tx[pos++] = b5;
	tx[pos++] = b2;
	tx[pos++] = b3;
	tx[pos++] = b0;
	tx[pos++] = b1;

	//load the address
	sprintf((char *)strr, "%02.2X", address);
	b1 = strr[0];
	b2 = strr[1];
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr
	
	//load the data
	sprintf((char *)strr, "%08.8X", data);
	b3 = strr[0];
	b4 = strr[1];
	b5 = strr[2];
	b6 = strr[3];
	b7 = strr[4];
	b8 = strr[5];
	b9 = strr[6];
	b10 = strr[7];
	tx[pos++] = b9;//data
	tx[pos++] = b10;//data
	tx[pos++] = b7;//data
	tx[pos++] = b8;//data
	tx[pos++] = b5;//data
	tx[pos++] = b6;//data
	tx[pos++] = b3;//data
	tx[pos++] = b4;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}







//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAddrLockBlock() 
{
	CString stra, str, str2;
	int address;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	UpdateData(TRUE);
	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}



	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	//0113 000304 186022 7265F423000007E0 01 0000 
	//build and send the Lock block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x33;//3

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x32;//2

	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];

	tx[pos++] = b14;//UID
	tx[pos++] = b15;
	tx[pos++] = b12;
	tx[pos++] = b13;
	tx[pos++] = b10;
	tx[pos++] = b11;
	tx[pos++] = b8;
	tx[pos++] = b9;
	tx[pos++] = b6;
	tx[pos++] = b7;
	tx[pos++] = b4;
	tx[pos++] = b5;
	tx[pos++] = b2;
	tx[pos++] = b3;
	tx[pos++] = b0;
	tx[pos++] = b1;

	//load the address
	address = hex2dec((char *)(LPCTSTR)m_Addr);	
	sprintf((char *)strr, "%02.2X", address);
	b1 = strr[0];
	b2 = strr[1];
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}





//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAddrReadMult() 
{
	CString str, str2;


	m_MiltiRead.ResetContent();
	m_MiltiRead.AddString("Reading...");
	m_MiltiRead.SetCurSel(0);
	UpdateWindow();


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}



	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}


	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header



	PurgePort();

	
	//determine the type of tag
	CString type;
	type = str2.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	if( (dtype == 0x00) || (dtype == 0x80))//HF-I Plus 
	{
		int index=0;
		m_MiltiRead.ResetContent();
		for(int x=0; x<8; x++)
		{
			for(int y=0; y<8; y++)
				data8[y]=0;

			Read8BlocksAddressed(x, str2);//data stored in data8[x]
			for(y=0; y<8; y++)
			{
				str.Format("%02.2X: %08.8X", index, data8[y]);
				index++;
				m_MiltiRead.AddString(str);
			}
		}
			m_MiltiRead.SetCurSel(0);
	}
   else//Pro/Standard Read (one block at a time)
   {
		AfxMessageBox("Only HF-I Plus tags support this function.");
		return;
   }

	
}





//**********************************************************************
void CRFID1AddressedCommandsDlg::Read8BlocksAddressed(int section, CString uid) //read 8 4-byte blocks starting at section
{
	char str_src[3000];
	char str_dest[3000];
	DWORD x;
	unsigned char tx[1000];//, rx[1000];//, strr[300];
	DWORD ret_bytes;
	CString stra, str;
	DWORD BytesWritten;

	for(x=0; x<2000; x++)
		grx[x] = 0;

	for(x=0; x<3000; x++)
	{
		str_src[x] = 0;
		str_dest[x] = 0;
	}
	
	//0114000304 182023 7065F423000007E0 00 07 0000
	//0114000304 186023 7065F423000007E0 00 07 0000

	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x33;//3

	unsigned char strr[30];
	sprintf((char *)strr, "%s", (LPCTSTR)uid);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];

	tx[pos++] = b14;//UID
	tx[pos++] = b15;
	tx[pos++] = b12;
	tx[pos++] = b13;
	tx[pos++] = b10;
	tx[pos++] = b11;
	tx[pos++] = b8;
	tx[pos++] = b9;
	tx[pos++] = b6;
	tx[pos++] = b7;
	tx[pos++] = b4;
	tx[pos++] = b5;
	tx[pos++] = b2;
	tx[pos++] = b3;
	tx[pos++] = b0;
	tx[pos++] = b1;


	if(section==0)//block 0-7
	{	
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
	}
	if(section==1)//block 8-15
	{	
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x38;//8
	}
	if(section==2)//block 16-23
	{	
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x30;//0
	}
	if(section==3)//block 24-31
	{	
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
	}

	if(section==4)//block 32-39
	{	
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x30;//0
	}
	if(section==5)//block 40-47
	{	
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x38;//8
	}
	if(section==6)//block 48-55
	{	
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
	}
	if(section==7)//block 56-63
	{	
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x38;//8
	}
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x37;//7
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	PurgePort();
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	ret_bytes = FastRead(159, 100);

	if(ret_bytes != 159)
	{
		AfxMessageBox("error1");

	   	//Initialize port ********************
		//set DTR
		FT_SetDtr(m_ftHandle);
		Sleep(20); //wait for cap to charge
		//Clear DTR
		FT_ClrDtr(m_ftHandle);
		Sleep(2010);//wait for micro to start up

		PurgePort();
		return;
	}


	pos=0;

	while(grx[pos++] != '[')//find starting brace
	{
		if((DWORD)pos>ret_bytes)
		{
			AfxMessageBox("error2");
			return;
		}	
	}

	pos+=4;
	stra.Format("");
	for(x=0; x<8; x++)
	{
		int count=8;
		str.Format("");
		while(count--)
		{
			stra.Format("%c", grx[pos++]);
			str+=stra;
		}
	
		pos+=2;
	
		data8[x] = 0;//init
		if(str.GetLength() ==8)//if a read was performed
		{
			strcpy(str_src, (LPCTSTR)str);
			//byte reverse
			int ptr=6;
			for(int t=0; t<8; t+=2)
			{
				str_dest[t] = str_src[ptr];
				str_dest[t+1] = str_src[ptr+1];
				str_dest[t+2] = NULL;
				ptr-=2;
			}
			data8[x] = hex2dec(str_dest);
		}
	}

	return;
}




//**********************************************************************
void CRFID1AddressedCommandsDlg::OnButtonDsfuidWrite() 
{
	CString stra, str, str2;
	int data;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	UpdateData(TRUE);
	if(m_DSFID.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	data = hex2dec((char *)(LPCTSTR)m_DSFID);	

	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	//build and send the DSFID Write command
	//0113 000304 186029 7165F423000007E0 67 0000 write 67
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x33;//3

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x39;//9

	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];

	tx[pos++] = b14;//UID
	tx[pos++] = b15;
	tx[pos++] = b12;
	tx[pos++] = b13;
	tx[pos++] = b10;
	tx[pos++] = b11;
	tx[pos++] = b8;
	tx[pos++] = b9;
	tx[pos++] = b6;
	tx[pos++] = b7;
	tx[pos++] = b4;
	tx[pos++] = b5;
	tx[pos++] = b2;
	tx[pos++] = b3;
	tx[pos++] = b0;
	tx[pos++] = b1;

	//load the data
	sprintf((char *)strr, "%02.2X", data);
	b1 = strr[0];
	b2 = strr[1];
	tx[pos++] = b1;//data
	tx[pos++] = b2;
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}







//**********************************************************************
void CRFID1AddressedCommandsDlg::OnButtonReadStatus() 
{
	unsigned char tx[1000], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	int nIndex, n;
	CString stra;
	char str_src[3000];
	char str_dest[3000];
	CString str;
	CString str2;

	
	KillTimer(100);

	UpdateData(TRUE);
	m_UID = " ";
	m_AFI.Format(" ");
	m_MemSize.Format(" ");
	m_DSFID_Status.Format(" ");
	m_TagType.Format(" ");
	UpdateData(FALSE);
	UpdateWindow();

	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}


	nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}

    n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header


	CString type;
	type = str2.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb
	
	UpdateData(TRUE);
	if(dtype == 0x00)//HF-I Plus Inlay
		m_TagType.Format("HF-I Plus Inlay");
	if(dtype == 0x80)//HF-I Plus Chip
		m_TagType.Format("HF-I Plus Chip");
	if(dtype == 0xC0)//Standard Chip / Inlay
		m_TagType.Format("Standard Chip / Inlay");
	if(dtype == 0xC4)//Pro Chip / Inlay
		m_TagType.Format("Pro Chip / Inlay");
	UpdateData(FALSE);
	UpdateWindow();


	if( (dtype == 0xC4) || (dtype == 0xC0) )//HF-I Standard/Pro
	{
		UpdateData(TRUE);
		m_UID = str2;
		DWORD data = ReadAddressedBlock(0x0A, str2); //read AFI
		data &= 0xFF;
		m_AFI.Format("%02.2X", data);
		m_MemSize.Format("N/A");
		m_DSFID_Status.Format("N/A");
		UpdateData(FALSE);
		UpdateWindow();
	}


	if( (dtype == 0x00) || (dtype == 0x80) )//HF-I Plus Inlay/chip
	{
		SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
		SendAgcToggle();
		SendAmPmToggle();
		//Request system info: 0112 000304 18202B 7065F423000007E0 0000
		//build and send the Read block command
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x32;//2

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4

		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x42;//B
		
		sprintf((char *)strr, "%s", (LPCTSTR)str2);
		int b0 = strr[0];
		int b1 = strr[1];
		int b2 = strr[2];
		int b3 = strr[3];
		int b4 = strr[4];
		int b5 = strr[5];
		int b6 = strr[6];
		int b7 = strr[7];
		int b8 = strr[8];
		int b9 = strr[9];
		int b10 = strr[10];
		int b11 = strr[11];
		int b12 = strr[12];
		int b13 = strr[13];
		int b14 = strr[14];
		int b15 = strr[15];

		tx[pos++] = b14;//UID
		tx[pos++] = b15;
		tx[pos++] = b12;
		tx[pos++] = b13;
		tx[pos++] = b10;
		tx[pos++] = b11;
		tx[pos++] = b8;
		tx[pos++] = b9;
		tx[pos++] = b6;
		tx[pos++] = b7;
		tx[pos++] = b4;
		tx[pos++] = b5;
		tx[pos++] = b2;
		tx[pos++] = b3;
		tx[pos++] = b0;
		tx[pos++] = b1;

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0

		PurgePort();

		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(100);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

		str.Format("%s", rx);
		if(str.GetLength() > 5)
		{
			pos = str.Find("[", 0);
			str = str.Mid(pos+1);
			pos = str.Find("]", 0);
			str = str.Left(pos);
			//m_SniffList.InsertString(0, str);
			//UpdateWindow();

			str = str.Mid(4);

			UpdateData(TRUE);
			//Display UID
			m_UID = str.Left(16);
			strcpy(str_src, (LPCTSTR)m_UID);
			//byte reverse
			int ptr=14;
			for(int t=0; t<16; t+=2)
			{
				str_dest[t] = str_src[ptr];
				str_dest[t+1] = str_src[ptr+1];
				str_dest[t+2] = NULL;
				ptr-=2;
			}
			m_UID.Format("%s", str_dest);

			//display DSFID & AFI
			m_DSFID_Status.Format("%s", str.Mid(16, 2) );
			m_AFI.Format("%s", str.Mid(18, 2) );
			m_MemSize.Format("%s", str.Mid(20, 4) );
			UpdateData(FALSE);
			UpdateWindow();
		}
	}


}



//0x30 = 0
//0x39 = 9
//0x41 = A
//0x42 = B
//0x43 = C
//0x44 = D
//0x45 = E
//0x46 = F

//***********************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonDsfidLock() 
{
	CString stra, str, str2;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header

	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	//build and send the DSFID Lock command
	//0112 000304 18602A 7165F423000007E0 0000
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x32;//2

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x41;//A

	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];

	tx[pos++] = b14;//UID
	tx[pos++] = b15;
	tx[pos++] = b12;
	tx[pos++] = b13;
	tx[pos++] = b10;
	tx[pos++] = b11;
	tx[pos++] = b8;
	tx[pos++] = b9;
	tx[pos++] = b6;
	tx[pos++] = b7;
	tx[pos++] = b4;
	tx[pos++] = b5;
	tx[pos++] = b2;
	tx[pos++] = b3;
	tx[pos++] = b0;
	tx[pos++] = b1;

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}






//**********************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAfiWrite() 
{
		unsigned char tx[1000], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;
	int nIndex, n;
	CString stra;
	CString str;
	CString str2;

	
	KillTimer(100);

	UpdateData(TRUE);
	m_UID = " ";
	m_AFI.Format(" ");
	m_MemSize.Format(" ");
	m_DSFID_Status.Format(" ");
	m_TagType.Format(" ");
	UpdateData(FALSE);
	UpdateWindow();

	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}


	nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}

    n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header


	CString type;
	type = str2.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb
	
	UpdateData(TRUE);
	if(dtype == 0x00)//HF-I Plus Inlay
		m_TagType.Format("HF-I Plus Inlay");
	if(dtype == 0x80)//HF-I Plus Chip
		m_TagType.Format("HF-I Plus Chip");
	if(dtype == 0xC0)//Standard Chip / Inlay
		m_TagType.Format("Standard Chip / Inlay");
	if(dtype == 0xC4)//Pro Chip / Inlay
		m_TagType.Format("Pro Chip / Inlay");
	UpdateData(FALSE);
	UpdateWindow();

	int data =  hex2dec((char *)(LPCTSTR)m_AFI2Write);	




	if( (dtype == 0xC4) || (dtype == 0xC0) )//HF-I Standard/Pro
	{
		UpdateData(TRUE);
		WriteAddressedBlock(0xA, data, str2);
	}


	if( (dtype == 0x00) || (dtype == 0x80) )//HF-I Plus Inlay/chip
	{
		SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
		SendAgcToggle();
		SendAmPmToggle();
		//Request system info: 0113 000304 186027 7065F423000007E0 0000

		//build and send the Read block command
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x33;//3

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4

		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
		tx[pos++] = 0x36;//6
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x37;//7
		
		sprintf((char *)strr, "%s", (LPCTSTR)str2);
		int b0 = strr[0];
		int b1 = strr[1];
		int b2 = strr[2];
		int b3 = strr[3];
		int b4 = strr[4];
		int b5 = strr[5];
		int b6 = strr[6];
		int b7 = strr[7];
		int b8 = strr[8];
		int b9 = strr[9];
		int b10 = strr[10];
		int b11 = strr[11];
		int b12 = strr[12];
		int b13 = strr[13];
		int b14 = strr[14];
		int b15 = strr[15];

		tx[pos++] = b14;//UID
		tx[pos++] = b15;
		tx[pos++] = b12;
		tx[pos++] = b13;
		tx[pos++] = b10;
		tx[pos++] = b11;
		tx[pos++] = b8;
		tx[pos++] = b9;
		tx[pos++] = b6;
		tx[pos++] = b7;
		tx[pos++] = b4;
		tx[pos++] = b5;
		tx[pos++] = b2;
		tx[pos++] = b3;
		tx[pos++] = b0;
		tx[pos++] = b1;

		//load the data
		sprintf((char *)strr, "%02.2X", data);
		b1 = strr[0];
		b2 = strr[1];
		tx[pos++] = b1;//data
		tx[pos++] = b2;

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0

		PurgePort();

		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(100);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	}
}




//**********************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAfiLock() 
{
	CString stra, str, str2;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header



	CString type;
	type = str2.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb
	
	UpdateData(TRUE);
	if(dtype == 0x00)//HF-I Plus Inlay
		m_TagType.Format("HF-I Plus Inlay");
	if(dtype == 0x80)//HF-I Plus Chip
		m_TagType.Format("HF-I Plus Chip");
	if(dtype == 0xC0)//Standard Chip / Inlay
		m_TagType.Format("Standard Chip / Inlay");
	if(dtype == 0xC4)//Pro Chip / Inlay
		m_TagType.Format("Pro Chip / Inlay");
	UpdateData(FALSE);
	UpdateWindow();

	int data =  hex2dec((char *)(LPCTSTR)m_AFI2Write);	


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	if( (dtype == 0xC4) || (dtype == 0xC0) )//HF-I Standard/Pro
	{
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x33;//3

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4

		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
		tx[pos++] = 0x36;//6
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x32;//2

		sprintf((char *)strr, "%s", (LPCTSTR)str2);
		int b0 = strr[0];
		int b1 = strr[1];
		int b2 = strr[2];
		int b3 = strr[3];
		int b4 = strr[4];
		int b5 = strr[5];
		int b6 = strr[6];
		int b7 = strr[7];
		int b8 = strr[8];
		int b9 = strr[9];
		int b10 = strr[10];
		int b11 = strr[11];
		int b12 = strr[12];
		int b13 = strr[13];
		int b14 = strr[14];
		int b15 = strr[15];

		tx[pos++] = b14;//UID
		tx[pos++] = b15;
		tx[pos++] = b12;
		tx[pos++] = b13;
		tx[pos++] = b10;
		tx[pos++] = b11;
		tx[pos++] = b8;
		tx[pos++] = b9;
		tx[pos++] = b6;
		tx[pos++] = b7;
		tx[pos++] = b4;
		tx[pos++] = b5;
		tx[pos++] = b2;
		tx[pos++] = b3;
		tx[pos++] = b0;
		tx[pos++] = b1;

		//load the address
		int address = 0x0A;	
		sprintf((char *)strr, "%02.2X", address);
		b1 = strr[0];
		b2 = strr[1];
		tx[pos++] = b1;//addr
		tx[pos++] = b2;//addr


		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0

		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(50);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	}


	if( (dtype == 0x00) || (dtype == 0x80) )//HF-I Plus Inlay/chip
	{
		//build and send the AFI Lock command for Plus tags
		//0112 000304 186028 7165F423000007E0 0000

		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x32;//2  do not change!!!

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4

		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
		tx[pos++] = 0x36;//6
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x38;//8

		sprintf((char *)strr, "%s", (LPCTSTR)str2);
		int b0 = strr[0];
		int b1 = strr[1];
		int b2 = strr[2];
		int b3 = strr[3];
		int b4 = strr[4];
		int b5 = strr[5];
		int b6 = strr[6];
		int b7 = strr[7];
		int b8 = strr[8];
		int b9 = strr[9];
		int b10 = strr[10];
		int b11 = strr[11];
		int b12 = strr[12];
		int b13 = strr[13];
		int b14 = strr[14];
		int b15 = strr[15];

		tx[pos++] = b14;//UID
		tx[pos++] = b15;
		tx[pos++] = b12;
		tx[pos++] = b13;
		tx[pos++] = b10;
		tx[pos++] = b11;
		tx[pos++] = b8;
		tx[pos++] = b9;
		tx[pos++] = b6;
		tx[pos++] = b7;
		tx[pos++] = b4;
		tx[pos++] = b5;
		tx[pos++] = b2;
		tx[pos++] = b3;
		tx[pos++] = b0;
		tx[pos++] = b1;

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0

		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(50);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	}
}




//0x30 = 0
//0x39 = 9
//0x41 = A
//0x42 = B
//0x43 = C
//0x44 = D
//0x45 = E
//0x46 = F

//**********************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAddrReadLockstate() 
{
	CString stra, str, str2;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	m_LockRead.ResetContent();
	m_LockRead.AddString("Reading...");
	m_LockRead.SetCurSel(0);
	UpdateWindow();

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}


	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header


	CString type;
	type = str2.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb
	
	UpdateData(TRUE);
	if(dtype == 0x00)//HF-I Plus Inlay
		m_TagType.Format("HF-I Plus Inlay");
	if(dtype == 0x80)//HF-I Plus Chip
		m_TagType.Format("HF-I Plus Chip");
	if(dtype == 0xC0)//Standard Chip / Inlay
		m_TagType.Format("Standard Chip / Inlay");
	if(dtype == 0xC4)//Pro Chip / Inlay
		m_TagType.Format("Pro Chip / Inlay");
	UpdateData(FALSE);
	UpdateWindow();

//	int data =  hex2dec((char *)(LPCTSTR)m_AFI2Write);	

	PurgePort();

	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	if( (dtype == 0x00) || (dtype == 0x80) )//HF-I Plus Inlay/chip
	{
		//0114 000304 18202C 7465F423000007E0 00 3F 0000
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x34;//4

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4

		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x43;//C

		sprintf((char *)strr, "%s", (LPCTSTR)str2);
		int b0 = strr[0];
		int b1 = strr[1];
		int b2 = strr[2];
		int b3 = strr[3];
		int b4 = strr[4];
		int b5 = strr[5];
		int b6 = strr[6];
		int b7 = strr[7];
		int b8 = strr[8];
		int b9 = strr[9];
		int b10 = strr[10];
		int b11 = strr[11];
		int b12 = strr[12];
		int b13 = strr[13];
		int b14 = strr[14];
		int b15 = strr[15];

		tx[pos++] = b14;//UID
		tx[pos++] = b15;
		tx[pos++] = b12;
		tx[pos++] = b13;
		tx[pos++] = b10;
		tx[pos++] = b11;
		tx[pos++] = b8;
		tx[pos++] = b9;
		tx[pos++] = b6;
		tx[pos++] = b7;
		tx[pos++] = b4;
		tx[pos++] = b5;
		tx[pos++] = b2;
		tx[pos++] = b3;
		tx[pos++] = b0;
		tx[pos++] = b1;

		//add start and end here...
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0

		tx[pos++] = 0x33;//3
		tx[pos++] = 0x46;//F

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0

		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(150);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);

		m_LockRead.ResetContent();

		for(DWORD x=0; x<BytesReturned; x++)
		{
			stra.Format("%c", rx[x]);
			str+=stra;
		}
		pos = str.Find("[", 0);
		str = str.Mid(pos+3);
			
		//load m_LockRead with data
		for(x=0; x<0x40; x++)
		{
			str2 = str.Left(2);		

			if(str2.Find("01", 0) >= 0)
				stra.Format("%02.2X: Locked", x);
			else
				stra.Format("%02.2X: Unlocked", x);
			m_LockRead.AddString(stra);

			str = str.Mid(2);
		}
		UpdateWindow();

		m_LockRead.SetCurSel(0);
	}
   else//Pro/Standard Read (one block at a time)
   {
		AfxMessageBox("Only HF-I Plus tags support this function.");
		return;
   }
}




//**********************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonKill() 
{
	CString stra, str, str2;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header

	UpdateData(TRUE);
	if(m_PW.GetLength() != 8)
	{
		AfxMessageBox("Invalid Entry.  Range: 00000000-FFFFFFFF");
		return;
	}

	int password = hex2dec((char *)(LPCTSTR)m_PW);	

	CString type;
	type = str2.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb
	
	UpdateData(TRUE);
	if(dtype == 0x00)//HF-I Plus Inlay
		m_TagType.Format("HF-I Plus Inlay");
	if(dtype == 0x80)//HF-I Plus Chip
		m_TagType.Format("HF-I Plus Chip");
	if(dtype == 0xC0)//Standard Chip / Inlay
		m_TagType.Format("Standard Chip / Inlay");
	if(dtype == 0xC4)//Pro Chip / Inlay
		m_TagType.Format("Pro Chip / Inlay");
	UpdateData(FALSE);
	UpdateWindow();

	PurgePort();

	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	if( (dtype == 0xC4) || (dtype == 0xC0) )//HF-I Standard/Pro
	{
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x37;//7

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4

		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
		tx[pos++] = 0x36;//6
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x41;//A
		tx[pos++] = 0x34;//4

		//add the IC Mfg Code
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x37;//7

	
		sprintf((char *)strr, "%s", (LPCTSTR)str2);
		int b0 = strr[0];
		int b1 = strr[1];
		int b2 = strr[2];
		int b3 = strr[3];
		int b4 = strr[4];
		int b5 = strr[5];
		int b6 = strr[6];
		int b7 = strr[7];
		int b8 = strr[8];
		int b9 = strr[9];
		int b10 = strr[10];
		int b11 = strr[11];
		int b12 = strr[12];
		int b13 = strr[13];
		int b14 = strr[14];
		int b15 = strr[15];

		tx[pos++] = b14;//UID
		tx[pos++] = b15;
		tx[pos++] = b12;
		tx[pos++] = b13;
		tx[pos++] = b10;
		tx[pos++] = b11;
		tx[pos++] = b8;
		tx[pos++] = b9;
		tx[pos++] = b6;
		tx[pos++] = b7;
		tx[pos++] = b4;
		tx[pos++] = b5;
		tx[pos++] = b2;
		tx[pos++] = b3;
		tx[pos++] = b0;
		tx[pos++] = b1;

		//add password here
		sprintf((char *)strr, "%08.8X", password);
		b3 = strr[0];
		b4 = strr[1];
		b5 = strr[2];
		b6 = strr[3];
		b7 = strr[4];
		b8 = strr[5];
		b9 = strr[6];
		b10 = strr[7];
		tx[pos++] = b9;//data
		tx[pos++] = b10;//data
		tx[pos++] = b7;//data
		tx[pos++] = b8;//data
		tx[pos++] = b5;//data
		tx[pos++] = b6;//data
		tx[pos++] = b3;//data
		tx[pos++] = b4;//data



		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0

		FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
		Sleep(150);
		FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
		FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	}
   else//Pro/Standard Tag
   {
		AfxMessageBox("Only HF-I Plus tags support this function.");
		return;
   }
		

}




//*************************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonAddrWriteWithpassword() 
{
	CString stra, str, str2;
	int address, data;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	UpdateData(TRUE);
	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	if(m_Data.GetLength() != 8)
	{
		AfxMessageBox("Invalid Entry.  Range: 00000000-FFFFFFFF");
		return;
	}

	address = hex2dec((char *)(LPCTSTR)m_Addr);	
	data =  hex2dec((char *)(LPCTSTR)m_Data);	


	if(m_PW.GetLength() != 8)
	{
		AfxMessageBox("Invalid Password Entry.  Range: 00000000-FFFFFFFF");
		return;
	}

	int password = hex2dec((char *)(LPCTSTR)m_PW);	


	//verify UID 
	int i = m_SniffList.GetSelCount();
	if(i!=1)
	{
		AfxMessageBox("Please select 1 tag.");
		return;
	}
	int nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}
    int n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header

	WriteAddressedBlockPassword(address, data, str2, password);
}



//0x30 = 0
//0x39 = 9
//0x41 = A
//0x42 = B
//0x43 = C
//0x44 = D
//0x45 = E
//0x46 = F


//*****************************************************************************
void CRFID1AddressedCommandsDlg::WriteAddressedBlockPassword(int address, int data, CString uid, int password)
{
	CString stra, str, str2;
	unsigned char tx[100], rx[1000], strr[30];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x41;//A
	tx[pos++] = 0x35;//5

	//IC Mfg Code
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x37;//7

	sprintf((char *)strr, "%s", (LPCTSTR)uid);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];

	tx[pos++] = b14;//UID
	tx[pos++] = b15;
	tx[pos++] = b12;
	tx[pos++] = b13;
	tx[pos++] = b10;
	tx[pos++] = b11;
	tx[pos++] = b8;
	tx[pos++] = b9;
	tx[pos++] = b6;
	tx[pos++] = b7;
	tx[pos++] = b4;
	tx[pos++] = b5;
	tx[pos++] = b2;
	tx[pos++] = b3;
	tx[pos++] = b0;
	tx[pos++] = b1;

	//Password
	sprintf((char *)strr, "%08.8X", password);
	b3 = strr[0];
	b4 = strr[1];
	b5 = strr[2];
	b6 = strr[3];
	b7 = strr[4];
	b8 = strr[5];
	b9 = strr[6];
	b10 = strr[7];
	tx[pos++] = b9;//data
	tx[pos++] = b10;//data
	tx[pos++] = b7;//data
	tx[pos++] = b8;//data
	tx[pos++] = b5;//data
	tx[pos++] = b6;//data
	tx[pos++] = b3;//data
	tx[pos++] = b4;//data



	//load the address
	sprintf((char *)strr, "%02.2X", address);
	b1 = strr[0];
	b2 = strr[1];
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr
	
	//load the data
	sprintf((char *)strr, "%08.8X", data);
	b3 = strr[0];
	b4 = strr[1];
	b5 = strr[2];
	b6 = strr[3];
	b7 = strr[4];
	b8 = strr[5];
	b9 = strr[6];
	b10 = strr[7];
	tx[pos++] = b9;//data
	tx[pos++] = b10;//data
	tx[pos++] = b7;//data
	tx[pos++] = b8;//data
	tx[pos++] = b5;//data
	tx[pos++] = b6;//data
	tx[pos++] = b3;//data
	tx[pos++] = b4;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}





//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonReadSerial() 
{
	char ErrorMessage[256];
	unsigned long ChipID = 0, NumDevices = 0;
	FTID_STATUS dStatus;
	CString str;

//	m_SniffList.ResetContent();
//	UpdateWindow();

	FT_Close(m_ftHandle);

	dStatus = FTID_GetDeviceChipID(0, &ChipID);
	if(dStatus == FTID_SUCCESS) 
	{
		str.Format(" 0x%X",  ChipID);			
		m_SniffList.InsertString(0,"ID:"+str);
	}
	else
	{
		FTID_GetErrorCodeString("EN", dStatus, ErrorMessage, 256);
		str.Format("Err: %s", ErrorMessage);
		m_SniffList.InsertString(0, str);
	}
	UpdateWindow();
	
	OpenPort(0, 0, 0);//reset, beep, notify_open in listbox


}



//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh1() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}



//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh2() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	
}

//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh3() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	
}

//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh4() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x38;//8
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	
}



//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh5() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x37;//7
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}



//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh6() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x35;//5
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}




//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh7() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}




//*****************************************************************************
void CRFID1AddressedCommandsDlg::OnButtonCh8() 
{
	unsigned char rx[1000], tx[1000];
	DWORD BytesWritten, AmountInRxQueue, BytesReturned;

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x39;//9
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
}
